#ifndef __miinam_dshow_h__
#define __miinam_dshow_h__

/* Version: 5.30405.20251228 */

#ifdef _WIN32
#ifndef _INC_WINDOWS
#include <windows.h>
#endif
#endif

#ifndef __MIINAMDEVIC_DEFINED__
#define __MIINAMDEVIC_DEFINED__

#define MIINAM_MAX             64

typedef struct {
    int idisable;   /* 0 = "support this feature", 1 = "not support" */
    int imin;       /* minimum value */
    int imax;       /* maximum value */
    int idef;       /* default value */
} MiinamRange;

#define MIINAM_PARA_UNKNOWN                0x00
#define MIINAM_PARA_EXPOTIME               0x01    /* exposure time */
#define MIINAM_PARA_AGAIN                  0x02    /* gain */
#define MIINAM_PARA_AEXPOTARGET            0x03    /* auto exposure target */
#define MIINAM_PARA_TEMP                   0x04    /* color temperature */
#define MIINAM_PARA_TINT                   0x05
#define MIINAM_PARA_CONTRAST               0x06    /* contrast */
#define MIINAM_PARA_HUE                    0x07    /* hue */
#define MIINAM_PARA_SATURATION             0x08    /* saturation */
#define MIINAM_PARA_BRIGHTNESS             0x09    /* brightness */
#define MIINAM_PARA_GAMMA                  0x0a    /* gamma */
#define MIINAM_PARA_AEXPO                  0x0b    /* auto exposure */
#define MIINAM_PARA_AWB                    0x0c    /* XCAM1080P:once;  XCAM4K:(0:manual;1:global auto;2:roi) */
#define MIINAM_PARA_BINSKIP                0x0d    /* bin / skip */
#define MIINAM_PARA_HZ                     0x0e    /* power supply: 0 -> 60HZ AC;  1 -> 50Hz AC;   2 -> DC */
#define MIINAM_PARA_BPS                    0x0f    /* bits per second, kbps */
#define MIINAM_PARA_KEYFRAME               0x10    /* key frame interval */
#define MIINAM_PARA_LOWLIGHTCOMPENSATION   0x11    /* low light compensation */
#define MIINAM_PARA_SHARPNESS              0x12    /* sharpness */
#define MIINAM_PARA_WBREDGAIN              0x13    /* white balance red gain */
#define MIINAM_PARA_WBGREENGAIN            0x14    /* white balance green gain */
#define MIINAM_PARA_WBBLUEGAIN             0x15    /* white balance blue gain */
#define MIINAM_PARA_DENOISE                0x16    /* denoise */
#define MIINAM_PARA_APSTA                  0x17    /* ap/sta */
#define MIINAM_PARA_CODEC                  0x18    /* codec, H264, H265, etc */
#define MIINAM_PARA_AFPOSITION             0x19    /* auto focus sensor board positon */
#define MIINAM_PARA_AFMODE                 0x1a    /* auto focus mode (0:manul focus; 1:auto focus; 2:once focus; 3:conjugate calibration) */
#define MIINAM_PARA_AFZONE                 0x1b    /* auto focus zone:
                                                       the whole resolution is divided in w * h zones:
                                                         w = imax >> 16
                                                         h = imax & 0xffff
                                                    */
#define MIINAM_PARA_AFFEEDBACK             0x1c    /* auto focus information feedback; 0:unknown; 1:focused; 2:focusing; 3:defocus; 4:up; 5:down */
#define MIINAM_PARA_AFPOSITION_ABSOLUTE    0x1d    /* absolute auto focus sensor board positon */
#define MIINAM_PARA_STATUS                 0x1e    /* status */
#define MIINAM_PARA_EVENT                  0x1f    /* event */
#define MIINAM_PARA_WBROILEFT              0x20    /* white balance roi left */
#define MIINAM_PARA_WBROITOP               0x21    /* white balance roi top */
#define MIINAM_PARA_WBROIWIDTH             0x22    /* white balance roi width */
#define MIINAM_PARA_WBROIHEIGHT            0x23    /* white balance roi height */
#define MIINAM_PARA_VFLIP                  0x24    /* vertical flip */
#define MIINAM_PARA_HFLIP                  0x25    /* horizontal flip */
#define MIINAM_PARA_CHROME                 0x26    /* monochromatic mode */
#define MIINAM_PARA_SIZE                   0x27    /* video width & height */

#define MIINAM_PARA_CHROME_LOCAL           0x80    /* local monochromatic mode */
#define MIINAM_PARA_VFLIP_LOCAL            0x81    /* local vertical flip */
#define MIINAM_PARA_HFLIP_LOCAL            0x82    /* local horizontal flip */
#define MIINAM_PARA_NEGATIVE_LOCAL         0x83    /* local negative film */

#define MIINAM_PARA_STATUS_RECORDING       0x00000001      /* recording */
#define MIINAM_PARA_STATUS_SD              0x00000002      /* sd card available */
#define MIINAM_PARA_STATUS_SD_FULL         0x00000004      /* sd card full */

#define MIINAM_PARA_EVENT_FAT4G            0x00000001      /* file size limit 4g in FAT32 */

#define MIINAM_STATE_INITING               0x00    /* initialization */
#define MIINAM_STATE_NORMAL                0x01    /* normal */
#define MIINAM_STATE_UNREACHABLE           0x02    /* network not reachable */

#define MIINAM_FLAG_WIFI_AP                0x0001  /* wifi ap */
#define MIINAM_FLAG_WIFI_STA               0x0002  /* wifi sta */
#define MIINAM_FLAG_ETHERNET               0x0004  /* eth network */
#define MIINAM_FLAG_CAPTURE                0x0008  /* support the ability of capture image from camera */
#define MIINAM_FLAG_AWBCHECKMODE           0x0010  /* auto white balance: check mode vs 'once' mode */
#define MIINAM_FLAG_UVC                    0x0020  /* uvc camera */
#define MIINAM_FLAG_WBGAIN                 0x0040  /* white balance gain mode or temp tint mode */
#define MIINAM_FLAG_MULTICAST              0x0080  /* RTSP/RTP multicast */
#define MIINAM_FLAG_AF                     0x0100  /* support auto focus */
#define MIINAM_FLAG_SD_LIST                0x0200  /* support to list sd card */
#define MIINAM_FLAG_SD                     0x0400  /* support sd card */
#define MIINAM_FLAG_WBROI                  0x0800  /* white balance: 0:manual;1:global auto;2:roi */
#define MIINAM_FLAG_RTP_OVER_RTSP          0x1000  /* rtp over rtsp */

typedef struct {
    char            id[64];         /* unique id, used for Miinam_Open */
    char            sn[64];         /* serial number */
    char            name[64];
    char            model[64];
    char            version[64];
    char            addr[64];       /* ip */
    char            url[256];       /* playback url, such as rtsp://xxxx/yyyy */
    unsigned        state;          /* MIINAM_STATE_xxx */
    unsigned        flag;           /* MIINAM_FLAG_xxx */
    MiinamRange    range[MIINAM_MAX];
} MiinamDevice;

#endif

/* Both the DirectShow source filter and the output pin support this interface.
    That is to say, you can use QueryInterface on the filter or the pin to get the IMiinam interface. */

// {F593CBB6-B326-4A55-9C99-B482EB1A104C}
DEFINE_GUID(IID_IMiinam, 0xf593cbb6, 0xb326, 0x4a55, 0x9c, 0x99, 0xb4, 0x82, 0xeb, 0x1a, 0x10, 0x4c);

DECLARE_INTERFACE_(IMiinam, IUnknown)
{
    STDMETHOD(get_Para) (THIS_ unsigned para, int* value) PURE;
    STDMETHOD(put_Para) (THIS_ unsigned para, int value) PURE;
    STDMETHOD(get_Device) (THIS_ MiinamDevice* p) PURE;
};

#endif
